/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.dao.impl.CapabilityDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractCapabilityVO;
import com.quantumdata.sct.dao.vo.DeviceCapabilityVO;
import com.quantumdata.sct.dao.vo.InputCapabilityVO;
import com.quantumdata.sct.dao.vo.ModelCapabilityVO;
import com.quantumdata.sct.dao.vo.OptionCapabilityVO;
import com.quantumdata.sct.gui.common.SCTCheckBox;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.wizard.InputSelectionPanel;
import com.quantumdata.sct.gui.wizard.OptionSelectionPanel;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDFCard
extends SCTPanel {
    private SCTCheckBox[] checkBox;
    private SCTPanel typeDependentPanel;
    private JPanel[] dispPanel;
    private Vector<ModelCapabilityVO.ModelCapabilityElementVO> mceVOList;
    private CapabilityDAO dao;
    private AbstractCapabilityVO[] capabilityVO;

    public CDFCard(String string, Vector<ModelCapabilityVO.ModelCapabilityElementVO> vector) {
        this.mceVOList = vector;
        this.preInit();
    }

    private void preInit() {
        this.setLayout(new BorderLayout());
        SCTPanel sCTPanel = new SCTPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        sCTPanel.setLayout(gridBagLayout);
        SCTSelection.instance().addHeaderInformation((JPanel)sCTPanel, this.mceVOList.get(0).getCapabilityId());
        this.add((Component)sCTPanel, "North");
        this.typeDependentPanel = this.init();
        this.add((Component)this.typeDependentPanel, "Center");
    }

    private SCTPanel init() {
        SCTPanel sCTPanel = new SCTPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        sCTPanel.setLayout(gridBagLayout);
        try {
            this.dao = (CapabilityDAO)XMLDAOFactory.getCapabilityDAO();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.checkBox = new SCTCheckBox[this.mceVOList.size()];
        this.dispPanel = new JPanel[this.mceVOList.size()];
        this.capabilityVO = new AbstractCapabilityVO[this.mceVOList.size()];
        boolean bl = false;
        for (int i = 0; i < this.mceVOList.size(); ++i) {
            ModelCapabilityVO.ModelCapabilityElementVO modelCapabilityElementVO = this.mceVOList.get(i);
            try {
                this.capabilityVO[i] = (AbstractCapabilityVO)((Object)this.dao.read(modelCapabilityElementVO.getCapabilityId()));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                bl = this.isMandatory(this.capabilityVO[i]);
                this.checkBox[i] = new SCTCheckBox();
                this.checkBox[i].setSelected(modelCapabilityElementVO.isSupported() || bl);
                this.checkBox[i].setEnabled(!bl);
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.anchor = 18;
                gridBagLayout.setConstraints(this.checkBox[i], gridBagConstraints);
                sCTPanel.add(this.checkBox[i]);
                this.dispPanel[i] = (this.capabilityVO[i] instanceof InputCapabilityVO || this.capabilityVO[i] instanceof OptionCapabilityVO) && modelCapabilityElementVO.getValue() != null ? this.capabilityVO[i].getDisplay(modelCapabilityElementVO.getValue()) : this.capabilityVO[i].getDisplay();
                gridBagConstraints.gridwidth = 0;
                sCTPanel.add((Component)this.dispPanel[i], gridBagConstraints);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return sCTPanel;
    }

    private boolean isMandatory(AbstractCapabilityVO abstractCapabilityVO) {
        try {
            IPersistable[] iPersistableArray = XMLDAOFactory.getDeviceCapabilityDAO().readAll();
            for (int i = 0; i < iPersistableArray.length; ++i) {
                DeviceCapabilityVO deviceCapabilityVO = (DeviceCapabilityVO)iPersistableArray[i];
                if (!deviceCapabilityVO.getDeviceId().equalsIgnoreCase(SCTSelection.instance().getDeviceID())) continue;
                AbstractCapabilityVO[] abstractCapabilityVOArray = deviceCapabilityVO.getMandatoryCapabilitiesVO();
                for (int j = 0; j < abstractCapabilityVOArray.length; ++j) {
                    if (!abstractCapabilityVOArray[j].getId().toString().equals(abstractCapabilityVO.getId().toString())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean finishAction() {
        for (int i = 0; i < this.mceVOList.size(); ++i) {
            ModelCapabilityVO.ModelCapabilityElementVO modelCapabilityElementVO = this.mceVOList.get(i);
            if (this.checkBox[i].isSelected() != modelCapabilityElementVO.isSupported()) {
                modelCapabilityElementVO.setSupported(this.checkBox[i].isSelected());
            }
            if (this.capabilityVO[i] instanceof InputCapabilityVO) {
                modelCapabilityElementVO.setValue(((InputSelectionPanel)this.dispPanel[i]).getTextValue());
            }
            if (!(this.capabilityVO[i] instanceof OptionCapabilityVO)) continue;
            modelCapabilityElementVO.setName(modelCapabilityElementVO.getCapabilityId() + "Options");
            modelCapabilityElementVO.setValue(((OptionSelectionPanel)this.dispPanel[i]).getTextValue());
        }
        return true;
    }
}

